'/**************************************/;
'/* Program Demo For ET-ROBOT RD2 V1.0 */;
'/* Controller  : P89C51RD2(Philips)   */;
'/* Run X-TAL   : 18.432 Mhz           */;
'/*             : X2 Mode(6 Cycle Run) */;
'/* Complier    : BASCOM-51(V2.0.11.0) */;
'/* Write By    : Eakachai Makarn      */;
'/* File Update : December-2003        */;
'/* Read A/D (ADS7841) & Show Volt LCD */;
'/* Used Library File "ET-7841.LIB"    */;
'/**************************************/;
'
$regfile = "89c51rd.dat"                                      'P89C51RD2(Philips)
$ramstart = 0
$ramsize = 256
$crystal = 36864000                                           '18.432MHz (X2 Mode)

Config Lcdpin = Pin , Db4 = P2.0 , Db5 = P2.1 , Db6 = P2.2 , Db7 = P2.3 , E = P2.4 , Rs = P2.5
Config Lcd = 16 * 2
Cursor Off                                                    'Not Display Cursor LCD

$lib "et-7841.lib"                                            'Include Library File
$external _ads7841                                            'Get Function From Library

Ads7841_dclk Alias P3.3                                       'Clock Input
Ads7841_cs Alias P3.4                                         'Chips Select
Ads7841_din Alias P3.5                                        'Data Input
Ads7841_dout Alias P3.7                                       'Data Output

Declare Sub Ads7841(ad_channel As Byte , Ad_result As Word)   'Sub Program For Read A/D
Dim Ad_channel As Byte                                        'Variable For Declare Channel A/D
Dim Ad_result As Word                                         'Variable For Save A/d Result
Dim Adc_calculate As Single                                   'Variable For Convert A/D Step to Volt
Dim Adc_display As String * 8

Cls                                                           'Clear Display
Lcd "DEMO ADS7841 A/D"
Locate 2 , 1                                                  'Line2 Position1
Lcd "ADC 0 =     Volt"
Do
  Ads7841 , 0 , Ad_result                                     'Read ADC CH0
  Adc_calculate = Ad_result                                   'Convert to Floating Point
  Adc_calculate = Adc_calculate * 0.0012210                   'Step * (5/4095)
  Adc_display = Fusing(adc_calculate , #.#)                   'Display 1 Digit Floating Point
  Locate 2 , 9                                                'Line2 Position 9
  Lcd Adc_display                                             'Display Result
Loop

Sub Ads7841(ad_channel As Byte , Ad_result As Word)
    $asm
      mov r0,#{ad_result}                                     ;Addres Low Byte Variable Save Data
      mov r1,{ad_channel}                                     ;Channel 0-3
      Lcall _ads7841                                          ;Call Libaray Function
    $end Asm
End Sub
